#!/bin/bash -xe

function lines()
{
    wc -l "$1"|cut -f 1 -d " "
}

# install not yet installed debian packages (but only run sudo if needed)
# todo: simplify
function debinstall()
{
    local I
    local N
    local NL
    local J
    N="$@"
    I=$(mktemp)
    # todo: handling of arch is ad-hoc
    dpkg-query -f '${binary:Package}\n' -W|cut -f 1 -d ":"|sort|uniq > $I
    NL=$(mktemp)
    for i in $N; do
        echo $i >> $NL
    done
    J=$(mktemp)
    join $I <(cat $NL|sort) > $J
    if ! [ "x$(lines $J)" = "x$(lines $NL)" ]; then
        sudo apt-get -y install $N
    else
        echo "All packages already installed."
    fi
    rm $I $NL
}

B=$(mktemp)
{
    debinstall bash build-essential curl expect git help2man openssl sudo zlib1g-dev zopfli
    pushd $(mktemp -d)
    # todo: aren't there signed releases?
    git clone 'https://github.com/practical-scheme/get-gauche.git'
    cd get-gauche
    # todo:
    # - remove --skip-tests again
    # - doesn't check signatures
    ./get-gauche.sh --keep-builddir --sudo --skip-tests --prefix /usr/local --auto
    popd
    gosh tools/build-standalone -o $B zs
    strip $B
    ldd $B
    # todo: ugly
    # i want to test the binary - but doing that in the working directory is a bad idea 
    mv -v zs zs.backup
    cp -v $B zs
    make check
    mv -v zs.backup zs
} >&2
cat $B
