#!/bin/bash -e
if [ "x$1" = "x" ]; then
    echo Version expected.
    exit 1
fi
VERSION="$1"

# todo:
# - is git tag -v good enough to verify the release?
# - isn't git already too dangerous?
# - gpg keyserver didn't work in schroot
schroot -c bookworm-amd64-sbuild --directory=/tmp -- bash -ex -c \
        'VERSION='"$VERSION"'; { sudo apt-get -y --no-install-recommends install ca-certificates git gpg
{ cat <<EOF
-----BEGIN PGP PUBLIC KEY BLOCK-----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=6bPO
-----END PGP PUBLIC KEY BLOCK-----
EOF
}|gpg --import
git clone "https://karme.de/git/zeichensalat"
cd zeichensalat
git tag -v "$VERSION"
git checkout "$VERSION" ; } >&2 && ./build-binary.sh'
