#!/bin/sh -e
trap 'echo Press enter to exit; read X' EXIT
if ! type zs >/dev/null 2>&1; then
    echo zs not found. Run ./binary-install.sh first.
    exit 1
fi

if [ "x$(head -n1 /usr/local/bin/zs)" = "x#!/bin/sh" ]; then
    echo Will not overwrite script file /usr/local/bin/zs with binary.
    exit 2
fi

VERSION="$(zs --version|cut -f 3 -d " ")"
LATEST="$(curl https://karme.de/zeichensalat/VERSION)"
if [ "x$VERSION" = "x$LATEST" ]; then
    echo "Already up to date ($VERSION)"
    exit 3
fi

D=$(mktemp)
curl https://karme.de/zeichensalat/zs.zs|zs -d > $D
sudo install $D /usr/local/bin/zs
rm $D
echo Installed to /usr/local/bin/zs.
zs --version
