#!/bin/sh
#| -*- mode: scheme; coding: utf-8; -*- |#
:; exec gosh -I. -- $0 "$@"
(use dbm.kyotocabinet)
(use gauche.dictionary)
(use text.progress)
(use util.sparse)

(define *db-file* "testdb.")

(define (make-dict type)
  (cond [(member type '(gdbm kch kct))
         (let* ((ext (symbol->string type))
                (name (string-append *db-file* ext))
                (dbclass (dbm-type->class
                          (case type
                            [(gdbm) 'gdbm]
                            [(kch) 'kyotocabinet]
                            [(kct) 'kyotocabinet]
                            [else
                             (error "huh?")]))))
           (dbm-db-remove dbclass name)
           (dbm-open dbclass
                     :rw-mode :create
                     :path name))]
        [(eq? type 'hash-table)
         (make-hash-table 'equal?)]
        [(eq? type 'sparse-table)
         (make-sparse-table 'equal?)]
        [(eq? type 'tree-map)
         (make-tree-map string=? string<?)]
        [else
         (error "unknown type" type)]))

(define (string-pattern s n)
  (apply string-append (map (lambda _ s) (iota n))))

(define (main args)
  (for-each
   (lambda(type close)
     (gc)
     (gc)
     (let1 dict (make-dict type)
       (time
        (unwind-protect
         (let* ((test-size 10000000)
                (p (make-text-progress-bar :header (symbol->string type)
                                           :max-value test-size
                                           :num-width 20)))
           (sys-srandom 0)
           (dotimes (i test-size)
             (when (zero? (remainder i 10000))
               (p 'inc 10000))
             (dict-put! dict
                        (number->string (sys-random))
                        (string-pattern (number->string (sys-random)) 5)))
           (p 'finish)
           ;;(dict-fold dict acons '())
           )
         (close dict)))))
   '(gdbm kch)
   (list dbm-close dbm-close)
   ;; '(gdbm kch kct hash-table sparse-table tree-map)
   ;; (list dbm-close dbm-close dbm-close (lambda _) (lambda _) (lambda _))
   )
  0)

