#!/bin/sh
#| -*- mode: scheme; coding: utf-8; -*- |#
:; exec gosh -I. -- $0 "$@"
(use dbm.kyotocabinet)
(define *db-file* "testdb.")

(define (equal*? . l)
  (if (= (length l) 2)
    (apply equal? l)
    (and (equal? (car l) (cadr l))
         (apply equal*? (cdr l)))))

(define (main args)
  (let1 r (apply equal*?
                 (map
                  (compose
                   (cute sort-by <> car)
                   (lambda(dbtype ext)
                     (let1 name (string-append *db-file* ext)
                           (dbm-db-remove (dbm-type->class dbtype) name)
                           (time
                            (let1 db (dbm-open (dbm-type->class dbtype)
                                               :rw-mode :create
                                               :path name)
                              (unwind-protect
                               (begin
                                 (sys-srandom 0)
                                 (dotimes (i 400000)
                                   (dbm-put! db
                                             (number->string (sys-random))
                                             (number->string (sys-random))))
                                 (dbm-fold db acons '()))
                               (dbm-close db)))))))
                  '(gdbm kyotocabinet kyotocabinet)
                  '("gdbm" "kch" "kct")))
    (when (not r)
      (error "not equal"))
    0))
