#!/bin/bash -xe
IFILE="$1"
NWIDTH="$2"
OFILE="$3"
test -f "$IFILE"
test 0 -lt "$NWIDTH"
WIDTH="$(gdalinfo "$IFILE"|grep ^Size|sed 's/Size is \([0-9]*\)\, [0-9]*/\1/g')"
HEIGHT="$(gdalinfo "$IFILE"|grep ^Size|sed 's/Size is [0-9]*\, \([0-9]*\)/\1/g')"
test 0 -lt "$HEIGHT"
test 0 -lt "$WIDTH"
gdal_translate -of vrt -srcwin $[WIDTH-NWIDTH] 0 $NWIDTH $HEIGHT "$IFILE" "$OFILE"
./gdal-offset "$OFILE" -360 || { rm -v "$OFILE" ; false ; }
