#!/bin/bash -xe
IFILE="$1"
WIDTH="$2"
OFILE="$3"
test -f "$IFILE"
test 0 -lt "$WIDTH"
HEIGHT="$(gdalinfo "$IFILE"|grep ^Size|sed 's/Size is [0-9]*\, \([0-9]*\)/\1/g')"
test 0 -lt "$HEIGHT"
gdal_translate -of vrt -srcwin 0 0 $WIDTH $HEIGHT "$IFILE" "$OFILE"
./gdal-offset "$OFILE" 360 || { rm -v "$OFILE" ; false ; }
